
**************************************************************************************************************************************************
******************* Code for 'RBA RDP: Examining the Macroeconomic Costs of Occupational Entry Regulations' *******************
***************************************************** Code for exntry exit regressions  ******************************************************************

**************************************************DATE: Jun 2024 ******************************************************************************
**************************************************** AUTHOR: Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
*00. Preliminaries and globals
*01. Bring in data
*02 Make key variables
*03 Regressions

************* 00. Preliminaries **********

sysdir set PLUS ""
sysdir set PERSONAL ""
global regs ""
global data ""


************* 01. Bring in data **********

use "$data\entry_emp1.dta" , clear // made in reallocation code - employing firms only

merge 1:1 fyear anzsic State using "$data\\entry_all1.dta", nogen // made in reallocation code - all firms

merge m:1 anzsic using "$data\\occ_lic_state.dta", nogen keep(master match) // merge occ data

g lic = nsw if State==1
replace lic = vic if State==2
replace lic = qld if State==3

 drop if fyear > 4019 // removing COVID period - note issue with fyear varialbe

 keep if lic!=.

 ************* 02. Make variavles **********

 ** Entry and exit rates
egen ind_st = group(anzsic State)
xtset ind_st fyear
foreach var in all emp {
	replace entry_`var' =. if fyear==4002 // removing first year where can't see entry
	g entry_`var'_r = entry_`var'/l.firm_`var'
	g entry_`var'_r_sm = entry_`var'/((l.firm_`var'+firm_`var')/2) // smoothed as share average firms
	g exit_`var'_r = exit_`var'/firm_`var'
	g churn_`var'_r= (entry_`var'+l.exit_`var')/((l.firm_`var'+firm_`var')/2)
}


tab fyear

** Remove extremem industries rates
preserve
xtset ind_st fyear
foreach var in all emp {
	replace entry_`var'_r = . if entry_`var'_r> 2*l.entry_`var'_r
	replace entry_`var'_r_sm = . if entry_`var'_r_sm > 2*l.entry_`var'_r_sm
	replace exit_`var'_r = . if exit_`var'_r> 2*l.exit_`var'_r
}

collapse(mean) entry_* exit_* churn_* lic poor (sum) firm_*, by( anzsic State)
 ************* 03. Regressions **********

 ** Include civil
foreach var in all emp {
	foreach ex in entry_`var'_r entry_`var'_r_sm exit_`var'_r {
		eststo clear
		eststo: reg `ex' lic , vce(cluster anzsic)
		eststo: areg `ex' lic, a(State) vce(cluster State)
		eststo: areg `ex' lic , a(anzsic) vce(cluster anzsic) // Core model
		eststo: areg `ex' lic i.State , a(anzsic) vce(cluster anzsic)

		esttab using "$regs\`ex'_clean.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	
		eststo clear
		
		reg `ex' i.anzsic 
		predict res_`ex' , residuals
	}
}


** Main regressions, removing civil		
	drop if inlist(anzsic,3101 , 3109, 6923)
foreach var in all emp {
	foreach ex in entry_`var'_r entry_`var'_r_sm exit_`var'_r {
		eststo clear
		eststo: reg `ex' lic , vce(cluster anzsic)
		eststo: areg `ex' lic, a(State) vce(cluster State)
		eststo: areg `ex' lic , a(anzsic) vce(cluster anzsic) // Core model
		eststo: areg `ex' lic i.State , a(anzsic) vce(cluster anzsic)

		esttab using "$regs\`ex'_ncivil_clean.csv", star(* 0.10 ** 0.05 *** 0.01)  stats(N r2 ar2) se replace	
		eststo clear
		
	
	}
}
restore


